/*
Version: 2.0, requires Writemonkey 2.7.0.0 or higher

Release date: September 8th 2014

Author: Josip

Description: 
Lightweight substitution for regular Jumps window with live updating. It plays nicely along with the Scratch pad plugin, functionally and visually.

Installation:
Unzip the "Easy jumps" directory into the plugins directory.

Deployment:
This plugin is initialized at startup.
 */


monkey.include("_config.incl");
monkey.include("_config_user.incl");
monkey.include("json2.incl");
monkey.include("_util.incl");
monkey.include("Logic.incl");



// GLobals / flags
var appLoaded = false;
var pluginActive = false;
var loadedItem = null;
var previousItem = null;
var loadedHash = "0";
var wordsSum = 0;
var activeWidth = 0;
var activeHeight = 0;
var isMinimized = false;

var isFind = false;
var matchesColl;

var numOfCharsTest = 0;
var selStartTest = 0;
var currentLineTest = 0;

var positionsArray = [];
var currentJumpViewIndex = 0;
var originalLocation = 0;

// Colors used
var bC = getColorFromName(BACKGROUND_COLOR);
var fC = getColorFromName(FOREGROUND_COLOR);

var tocString;

// Background worker
var worker = new System.ComponentModel.BackgroundWorker();

var timer = new System.Windows.Forms.Timer();
timer.Interval = 800;
timer.Start();


// var timer2 = new System.Windows.Forms.Timer();
// timer2.Interval = 300;
// timer2.Start();

/*************************************************************************
 *                                                                        *
 *     UI                                                                 *
 *                                                                        *
 *************************************************************************/


// Plugin form
var pluginForm = monkey.getBlankPluginForm(400, 600);
var listView = monkey.getBlankListView();
var tableLayoutPanel1 = new System.Windows.Forms.TableLayoutPanel();
var panel1 = new System.Windows.Forms.Panel();
var panel2 = new System.Windows.Forms.Panel();
var blankPanel = new System.Windows.Forms.Panel();
var textBox1 = new System.Windows.Forms.TextBox();
var clearLabel = new System.Windows.Forms.Label();
var minimizeLabel = new System.Windows.Forms.Label();
minimizeLabel.Visible = false;
var optionsLabel = new System.Windows.Forms.Label();
var jumpLabel = new System.Windows.Forms.Label();

var optionsContextMenuStrip = new System.Windows.Forms.ContextMenuStrip();
var filterContextMenuStrip = new System.Windows.Forms.ContextMenuStrip();

// Filter context menu
filterContextMenuStrip.ShowImageMargin = false;
filterContextMenuStrip.ShowShortcutKeys = false;
filterContextMenuStrip.Font = new System.Drawing.Font(UI_FONT_NAME, filterContextMenuStrip.Font.Size, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
setJumpsContextMenu();


// Options context menu
optionsContextMenuStrip.ShowImageMargin = false;
optionsContextMenuStrip.ShowShortcutKeys = false;
optionsContextMenuStrip.Font = new System.Drawing.Font(UI_FONT_NAME, optionsContextMenuStrip.Font.Size, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);

var copyAsTextMenuItem = new System.Windows.Forms.ToolStripMenuItem(COPY_AS_STRING_S);
copyAsTextMenuItem.Tag = "copy_string";
optionsContextMenuStrip.Items.Add(copyAsTextMenuItem);


pluginForm.Padding = new System.Windows.Forms.Padding(10);
pluginForm.BackColor = bC;
pluginForm.deactivatedOpacity = DEACTIVATED_OPACITY;
pluginForm.showMinimizeButton = false;
pluginForm.mouseCapturing = false;
pluginForm.MinimumSize = new System.Drawing.Size(100, 95);
pluginForm.roundedCorners = ROUNDED_CORNERS;

tableLayoutPanel1.BackColor = bC;
tableLayoutPanel1.ColumnCount = 1;
tableLayoutPanel1.ColumnStyles.Add(new System.Windows.Forms.ColumnStyle(System.Windows.Forms.SizeType.Percent, 100));
tableLayoutPanel1.Controls.Add(listView, 0, 2);
tableLayoutPanel1.Controls.Add(panel1, 0, 0);
tableLayoutPanel1.Controls.Add(panel2, 0, 3);
tableLayoutPanel1.Dock = System.Windows.Forms.DockStyle.Fill;
tableLayoutPanel1.Location = new System.Drawing.Point(10, 10);
tableLayoutPanel1.Margin = new System.Windows.Forms.Padding(0);
tableLayoutPanel1.RowCount = 4;
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 30));
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 8));
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Percent, 100));
tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 30));
tableLayoutPanel1.Size = new System.Drawing.Size(251, 372);
tableLayoutPanel1.TabIndex = 0;


listView.backColor = bC;
listView.foreColor = fC;


listView.Dock = System.Windows.Forms.DockStyle.Fill;
listView.HideSelection = false;
listView.Font = new System.Drawing.Font(LIST_FONT_NAME, TEXT_SIZE, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
listView.Padding = new System.Windows.Forms.Padding(0);
listView.BackColor = bC;
listView.FullRowSelect = true;
listView.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
listView.HotTracking = false;
listView.HoverSelection = false;
listView.MultiSelect = false;
listView.ShowItemToolTips = SHOW_TOOLTIPS;

listView.Columns.Add("#1", 150, System.Windows.Forms.HorizontalAlignment.Right);
listView.Columns.Add("#2", 25, System.Windows.Forms.HorizontalAlignment.Left);
listView.Columns.Add("#3", 70, System.Windows.Forms.HorizontalAlignment.Right);
listView.Columns.Add("#4", 40, System.Windows.Forms.HorizontalAlignment.Right);


panel1.BackColor = fC;
panel1.Dock = System.Windows.Forms.DockStyle.Fill;
panel1.Location = new System.Drawing.Point(0, 0);
panel1.Margin = new System.Windows.Forms.Padding(0);
panel1.Padding = new System.Windows.Forms.Padding(0);
// panel1.Name = "panel1";
// panel1.Size = new System.Drawing.Size(0, 0);
//panel1.Visible = false;

panel2.BackColor = bC;
panel2.Dock = System.Windows.Forms.DockStyle.Fill;
panel2.Location = new System.Drawing.Point(0, 0);
panel2.Margin = new System.Windows.Forms.Padding(0);
panel2.Padding = new System.Windows.Forms.Padding(0);
// panel2.Size = new System.Drawing.Size(0, 0);

textBox1.BackColor = fC;
textBox1.ForeColor = bC;
textBox1.BorderStyle = System.Windows.Forms.BorderStyle.None;
textBox1.Font = new System.Drawing.Font(UI_FONT_NAME, 10, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
textBox1.Location = new System.Drawing.Point(10, 7);
// textBox1.Name = "textBox1";
textBox1.Size = new System.Drawing.Size(panel1.Width - 50, 17);
textBox1.ContextMenuStrip = new System.Windows.Forms.ContextMenuStrip();
textBox1.AcceptsTab = true;
textBox1.TabIndex = 0;


clearLabel.ForeColor = bC;
clearLabel.Anchor = System.Windows.Forms.AnchorStyles.Right;
clearLabel.AutoSize = true;
clearLabel.Location = new System.Drawing.Point(0, 0);
clearLabel.Size = new System.Drawing.Size(0, 0);
clearLabel.Font = new System.Drawing.Font(UI_FONT_NAME, 8, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
clearLabel.Cursor = System.Windows.Forms.Cursors.Hand;
clearLabel.TabIndex = 1;
clearLabel.Text = CLEAR_S;


minimizeLabel.AutoSize = false;
minimizeLabel.Font = new System.Drawing.Font("Arial", 9, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
minimizeLabel.Cursor = System.Windows.Forms.Cursors.Hand;
minimizeLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
minimizeLabel.Dock = System.Windows.Forms.DockStyle.Fill;


jumpLabel.ForeColor = fC;
jumpLabel.Anchor = System.Windows.Forms.AnchorStyles.Left;
jumpLabel.AutoSize = true;
jumpLabel.Location = new System.Drawing.Point(0, 0);
jumpLabel.Size = new System.Drawing.Size(0, 0);
jumpLabel.Font = new System.Drawing.Font(UI_FONT_NAME, 8.5, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
jumpLabel.Cursor = System.Windows.Forms.Cursors.Hand;
jumpLabel.TabIndex = 1;
jumpLabel.Text = "";


optionsLabel.ForeColor = fC;
optionsLabel.Anchor = System.Windows.Forms.AnchorStyles.Left;
optionsLabel.AutoSize = true;
optionsLabel.Location = new System.Drawing.Point(0, 0);
// optionsLabel.Size = new System.Drawing.Size(0, 0);
optionsLabel.Font = new System.Drawing.Font(UI_FONT_NAME, 10.3, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
optionsLabel.Cursor = System.Windows.Forms.Cursors.Hand;
optionsLabel.TabIndex = 1;
optionsLabel.Text = OPTIONS_S;


pluginForm.Controls.Add(tableLayoutPanel1);
pluginForm.Controls.Add(minimizeLabel);
pluginForm.Controls.Add(blankPanel);
panel1.Controls.Add(clearLabel);
panel1.Controls.Add(textBox1);
panel2.Controls.Add(jumpLabel);
panel2.Controls.Add(optionsLabel);


positionElements();
colorElements();
// END UI //



/*************************************************************************
 *                                                                        *
 *     GLOBAL EVENTS                                                      *
 *                                                                        *
 *************************************************************************/


pluginForm.add_Paint(function(object, eventargs) {
	if (pluginForm.BackColor == monkey.paperColor && BORDER_ON_SAME_BACKGROUND) {
		var rect = new System.Drawing.Rectangle(0, 0, pluginForm.Width - 2, pluginForm.Height - 2);
		var pen = new System.Drawing.Pen(fC, 1);
		pen.DashStyle = System.Drawing.Drawing2D.DashStyle.Dot;
		eventargs.Graphics.DrawRectangle(pen, rect);
	}	
});



panel1.add_Paint(function(object, eventargs) {
	var pg = panel1.CreateGraphics();
	//pg.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
	var rect = new System.Drawing.Rectangle(1, 1, panel1.Width - 2, panel1.Height - 2);
	var pen = new System.Drawing.Pen(fC, 1);
	pen.DashStyle = System.Drawing.Drawing2D.DashStyle.Dot;
	//pg.DrawRectangle(pen, rect);
	pg.DrawLine(pen, 1, panel1.Height - 1, panel1.Width - 1, panel1.Height - 1);
	pg.Dispose();
});


worker.add_DoWork(function(object, eventargs) {
	setMatches();
});



worker.add_RunWorkerCompleted(function(object, eventargs) {
	updateListView();
});

var numOfLinesTest;
var previousLineIndex;
var doUpdate = false;



timer.add_Tick(function(object, eventargs) {
	if (isMinimized) return;

	// Update in the background
	if (numOfLinesTest != monkey.richTextBox.Lines.Length) {
		if (worker.IsBusy != true) {
			worker.RunWorkerAsync();
			// monkey.playSound();

		}
	}
});


monkey.richTextBox.add_TextChanged(function(object, eventargs) {

});



monkey.richTextBox.add_SelectionChanged(function(object, eventargs) {
	// resetTimer();
});


monkey.richTextBox.add_MouseClick(function(object, eventargs) {
	if (isMinimized) return;
	previousLineIndex = monkey.richTextBox.GetLineFromCharIndex(monkey.richTextBox.SelectionStart);
	forceUpdateListView();
});



//////////////////////////////


monkey.form.add_Click(function(object, eventargs) {

});


pluginForm.add_DoubleClick(function(object, eventargs) {
	minimizePlugin();
});



// Will handle file name changes and deactivate plugin if not in scratch mode
// This event can fire redundantly

monkey.form.add_FileNameChanged(function(object, eventargs) {

});

// Will handele new file (scratch) command and will create new blank note
monkey.richTextBox.add_NewScratch(function(object, eventargs) {

});

// Will listen for save command and cancel if in scratch mode
monkey.add_beforeSaveE(function(object, eventargs) {
	forceUpdateListView();
});

// On focus
pluginForm.add_Activated(function(object, eventargs) {
	originalLocation = monkey.richTextBox.SelectionStart;
	// forceUpdateListView();
	blankPanel.Visible = false;
});

// On lost focus
pluginForm.add_Deactivate(function(object, eventargs) {
	blankPanel.BackColor = bC;
	blankPanel.SetBounds(listView.Right - System.Windows.Forms.SystemInformation.VerticalScrollBarWidth + 4, listView.Location.Y + 4, System.Windows.Forms.SystemInformation.VerticalScrollBarWidth + 10, listView.Height + 10);
	if (minimizeLabel.Visible == false) blankPanel.Visible = true;
	blankPanel.BringToFront();

});

listView.add_DoubleClick(function(object, eventargs) {
	//SHOW_HEADING_NUMBERS = (SHOW_HEADING_NUMBERS) ? false : true;
	//updateListView();
});

listView.add_MouseEnter(function(object, eventargs) {

});


pluginForm.add_MouseUp(function(object, eventargs) {

});


pluginForm.add_SizeChanged(function(object, eventargs) {
	positionElements();
});

monkey.richTextBox.add_ForeColorChanged(function(object, eventargs) {
	colorElements();
});

textBox1.add_TextChanged(function(object, eventargs) {
	numOfLinesTest = monkey.richTextBox.Lines.Length - 1;
	resetTimer();
	if (textBox1.Text.StartsWith("=") && textBox1.Text.Length >= 3) {
		isFind = true;
	} else {
		isFind = false;
	}
});


textBox1.add_MouseDown(function(object, eventargs) {

});


// var previousCharCount;
monkey.richTextBox.add_KeyDown(function(object, eventargs) {
	if (eventargs.KeyCode == System.Windows.Forms.Keys.Enter) {
		resetTimer();
	}
	else if (eventargs.KeyCode == System.Windows.Forms.Keys.D3 && System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control) {
		listView.Focus();
	}
});


clearLabel.add_Click(function(object, eventargs) {
	textBox1.Clear();
});



jumpLabel.add_Click(function(object, eventargs) {
	filterContextMenuStrip.Show(new System.Drawing.Point(System.Windows.Forms.Cursor.Position.X, System.Windows.Forms.Cursor.Position.Y));
});


filterContextMenuStrip.add_ItemClicked(function(object, eventargs) {
	currentJumpViewIndex = eventargs.ClickedItem.Tag;
	jumpLabel.Text = JUMP_DEFINITIONS[currentJumpViewIndex][0];
	positionElements();
	forceUpdateListView();
});


optionsLabel.add_Click(function(object, eventargs) {
	optionsContextMenuStrip.Show(new System.Drawing.Point(System.Windows.Forms.Cursor.Position.X, System.Windows.Forms.Cursor.Position.Y));
});


minimizeLabel.add_Click(function(object, eventargs) {
	maximizePlugin();
});


listView.add_ItemSelectionChanged(function(object, eventargs) {
	// monkey.playSound();
	jumpToPlace(eventargs.Item.Tag);
});

listView.add_SelectedIndexChanged(function(object, eventargs) {
	//jumpToPlace(listView.SelectedItems[0].Tag);

});


listView.add_ItemActivate(function(object, eventargs) {
	monkey.richTextBox.Focus();
});


// Save active on exit
monkey.add_appClosingE(function(object, eventargs) {
	saveUserData();
});


// Manage soft exit
monkey.form.add_VisibleChanged(function(object, eventargs) {
	// if (monkey.form.Visible == false) {
	// 	pluginForm.Visible = false;
	// } else if (monkey.form.Visible == true) {
	// 	pluginForm.Visible = true;
	// }
});



monkey.add_beforeOpenE(function(object, eventargs) {

});



// Initialize plugin on startup
// ENTRY POINT
monkey.add_appLoadedE(function(object, eventargs) {
	activatePlugin();
});



/*************************************************************************
 *                                                                        *
 *     KEYBOARD COMMANDS                                                  *
 *                                                                        *
 *************************************************************************/


listView.add_KeyDown(function(object, eventargs) {
	if (eventargs.KeyCode == System.Windows.Forms.Keys.Right) {
		toggleJumps(false);
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Left) {
		toggleJumps(true);
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Up) {
		if (listView.Items[0].Selected == true) {
			textBox1.Focus();
		}
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Back) {
		jumpToPlace([originalLocation, 0]);
		updateListView();
	} else if (System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control && (eventargs.KeyCode == System.Windows.Forms.Keys.D0 || eventargs.KeyCode == System.Windows.Forms.Keys.Delete)) {
		textBox1.Clear();
	}

});

textBox1.add_KeyDown(function(object, eventargs) {
	if (System.Windows.Forms.Control.ModifierKeys == System.Windows.Forms.Keys.Control && (eventargs.KeyCode == System.Windows.Forms.Keys.D0 || eventargs.KeyCode == System.Windows.Forms.Keys.Delete)) {
		textBox1.Clear();
	} else if (eventargs.KeyCode == System.Windows.Forms.Keys.Down) {
		listView.Focus();
	}
});


/*************************************************************************
 *                                                                        *
 *     MENU COMMANDS                                                      *
 *                                                                        *
 *************************************************************************/


optionsContextMenuStrip.add_ItemClicked(function(object, eventargs) {

	optionsContextMenuStrip.Hide();

	if (eventargs.ClickedItem.Tag == "copy_string") {
		try {
			System.Windows.Forms.Clipboard.SetText(tocString);
		} catch (e) {

		}
	}
});